/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (HexFileLine.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: HexFileLine.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx;

/**
 * @author martin
 */
class HexFileLine {

    public static final short DATA_RECORD = 0;
    public static final short EOF_RECORD = 1;
    public static final short EXTENDED_SEGMENT_ADDRESS_RECORD = 2;
    public static final short EXTENDED_LINEAR_ADDRESS_RECORD = 4;
    
    private int recordLength = 0; 
    private int address = 0;
    private int recordType = 0;
    private byte[] data = null;  
    private int checkSum = -1;

    public static final HexFileLine EOF = new HexFileLine();

    static {
        EOF.setRecordLength(0);
        EOF.setAddress(0);
        EOF.setRecordType(EOF_RECORD);
        EOF.setCheckSum();
    }
    
    /**
     * 
     */
    public HexFileLine() {
        super();
    }
    
    /**
     * calculate the checksum I should have.
     * @return the calculated checksum
     */
    public int calcCheckSum() {
        int sum = 0;
        sum += recordLength;
        sum += getAddress() / 256;
        sum += getAddress() % 256;
        sum += getRecordType();
        for (int i = 0; i < data.length; i++) {
            short val = this.getData(i);
            if ( val < 0 ) val = (short) (256 + val);
            sum += val;
        }
        sum = -(sum % 256);
        if( sum < 0 ) {
            return 256+sum;
        } else {
            return sum;
        }
    }

    /**
     * calculate the checksum and update myself 
     */
    public void setCheckSum() {
        this.setCheckSum(this.calcCheckSum());
    }

    /**
     * Set my record length
     * @param len
     */
    public void setRecordLength( int len ) {
        this.recordLength = len;
        this.data = new byte[ len ];
    }
    
    /**
     * @return
     */
    public int getRecordLength() {
        return this.recordLength;
    }
    
    /**
     * @param i
     * @param b
     */
    public void setData(int i, byte b) {
        this.data[i]=b;
    }
    
    /**
     * @param i
     * @return
     */
    public byte getData(int i) {
        return this.data[i];
    }
    
    /**
     * @param address The address to set.
     */
    public void setAddress(int address) {
        this.address = address;
    }

    /**
     * @return Returns the address.
     */
    public int getAddress() {
        return this.address;
    }

    /**
     * @param recordType The recordType to set.
     */
    public void setRecordType(int recordType) {
        this.recordType = recordType;
    }

    /**
     * @return Returns the recordType.
     */
    public int getRecordType() {
        return this.recordType;
    }

    /**
     * @param checkSum The checkSum to set.
     */
    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    /**
     * @return Returns the checkSum.
     */
    public int getCheckSum() {
        return checkSum;
    }
    
}
